/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.value;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.ConfigValue;
import me.jddev0.ep.config.validation.ValueValidator;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentifierListConfigValue
extends ConfigValue<List<class_2960>> {
    public IdentifierListConfigValue(@NotNull String key, @NotNull @NotNull List<@NotNull class_2960> defaultValue) {
        this(key, (String)null, defaultValue);
    }

    public IdentifierListConfigValue(@NotNull String key, @Nullable String comment, @NotNull @NotNull List<@NotNull class_2960> defaultValue) {
        this(key, comment, defaultValue, (ValueValidator<List<class_2960>>)null);
    }

    public IdentifierListConfigValue(@NotNull String key, @Nullable String comment, @NotNull @NotNull List<@NotNull class_2960> defaultValue, @Nullable ValueValidator<List<@NotNull class_2960>> customValidator) {
        super(key, comment, new ArrayList<class_2960>(defaultValue), customValidator);
    }

    @Override
    @NotNull
    public List<String> getValidationCommentLines() {
        ArrayList<String> commentLines = new ArrayList<String>();
        commentLines.add("Syntax (whitespaces are ignored): [namespace1:path1, namespace2:path2, ...]");
        commentLines.addAll(super.getValidationCommentLines());
        return commentLines;
    }

    @Override
    public void validate(@NotNull @NotNull List<@NotNull class_2960> value) throws ConfigValidationException {
        super.validate(value);
    }

    @Override
    @NotNull
    protected @NotNull List<@NotNull class_2960> readInternal(@NotNull String rawValue) throws ConfigValidationException {
        if (rawValue.equals("[]")) {
            return new ArrayList<class_2960>(0);
        }
        if (!rawValue.startsWith("[") || !rawValue.endsWith("]")) {
            throw new ConfigValidationException("List syntax: Must start with \"[\" and end with \"]\"");
        }
        if ((rawValue = rawValue.substring(1, rawValue.length() - 1).trim()).startsWith(",") || rawValue.endsWith(",")) {
            throw new ConfigValidationException("Value must not start with \"[,\" or end with \",]\"");
        }
        ArrayList<@NotNull class_2960> identifiers = new ArrayList<class_2960>();
        String[] tokens = rawValue.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].trim();
            if (token.isEmpty()) {
                throw new ConfigValidationException("Value must not be empty at index " + i);
            }
            class_2960 identifier = class_2960.method_12829((String)token);
            if (identifier == null) {
                throw new ConfigValidationException("Invalid value at index " + i + ": \"" + token + "\"");
            }
            identifiers.add(identifier);
        }
        return new ArrayList<class_2960>(identifiers);
    }

    @Override
    @NotNull
    protected String writeInternal(@NotNull @NotNull List<@NotNull class_2960> value) {
        StringBuilder builder = new StringBuilder("[");
        for (class_2960 Identifier : value) {
            builder.append(Identifier).append(", ");
        }
        if (!value.isEmpty()) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("]");
        return builder.toString();
    }
}

